﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter2__Neapolitan_
{
    class Program
    {
        #region Question 3
        static int BinSearch2(int[] array, int key, int low, int high)
        {
            int mid = (low + high) / 2;
            if (array[mid] == key)
                return mid;
            else if (array[mid] > key)
                return BinSearch2(array, key, low, mid - 1);
            else
                return BinSearch2(array, key, mid + 1, high);
        }
        #endregion
        #region Question 6
        static int BinSearch3(int[] array, int key, int low, int high)
        {
            if (low > high)
                return -1;
            int len = high - low + 1;
            int mid1 = low + len / 3;
            int mid2 = high - len / 3;
            if (array[mid1] == key)
                return mid1;
            if (array[mid2] == key)
                return mid2;
            if (array[mid1] > key)
                return BinSearch3(array, key, low, mid1 - 1);
            if (array[mid2] > key)
                return BinSearch3(array, key, mid1 + 1, mid2 - 1);
            return BinSearch3(array, key, mid2 + 1, high);
        }
        #endregion
        #region Question 7
        static void FindMax(int[] array, ref int Max, int low, int high)
        {
            if (low == high)
            {
                if (array[low] > Max)
                    Max = array[low];
            }
            else
            {
                int mid = (low + high) / 2;
                FindMax(array, ref Max, low, mid);
                FindMax(array, ref Max, mid + 1, high);
            }
        }
        #endregion
        #region Question 10
        static void MaxPartition(int[] array, out int[] Part1, out int[] Part2)
        {
            int j = 0;
            Part1 = new int[array.Length / 2];
            Part2 = new int[array.Length / 2];
            MergeSort(array, 0, array.Length - 1);        // Complexity of this algorithm depend on SortAlgorithm that used
            for (int i = 0; i < Part1.Length; i++)
                Part1[i] = array[j++];
            for (int i = 0; i < Part2.Length; i++)
                Part2[i] = array[j++];
        }
        static void MergeSort(int[] array, int low, int high)
        {
            if (low < high)
            {
                int mid = (low + high) / 2;
                MergeSort(array, low, mid);
                MergeSort(array, mid + 1, high);
                Merge(array, low, mid, high);
            }
        }
        static void Merge(int[] array, int low, int mid, int high)
        {
            int[] temp = new int[high - low + 1];
            int i = low, j = mid + 1, k = 0;
            while (i <= mid && j <= high)
            {
                if (array[i] < array[j])
                    temp[k++] = array[i++];
                else
                    temp[k++] = array[j++];
            }
            if (i > mid)
            {
                while (j <= high)
                    temp[k++] = array[j++];
            }
            else
            {
                while (i <= mid)
                    temp[k++] = array[i++];
            }
            i = low;
            k = 0;
            while (i <= high)
                array[i++] = temp[k++];
        }
        #endregion
        #region Question 11
        static void MergeSort2(int[] array)
        {
            int high;
            for (int i = 2; i <= 2 * array.Length; i *= 2) //len mohem nist ama baraye tedade farde anasor bayad hatman halghe bishaz len araye edame dahad
                for (int j = 0; j < array.Length; j += i)
                {
                    high = j + i - 1;
                    if (high >= array.Length)
                        high = array.Length - 1;
                    if (high > j)
                        Merge(array, j, j + i / 2 - 1, high);
                }
        }
        #endregion
        #region Question 13
        static void MergeSort3(int[] array, int low, int high)
        {
            if (low < high)
            {
                int len = high - low + 1;
                int mid1 = low + len / 3;
                int mid2 = high - len / 3;

                MergeSort3(array, low, mid1);
                MergeSort3(array, mid1 + 1, mid2);
                MergeSort3(array, mid2 + 1, high);

                Merge(array, low, mid1, mid2);
                Merge(array, low, mid2, high);
            }
        }
        #endregion
        #region Question 17
        static void Hanoi(int num, char start, char temp, char end)
        {
            if (num == 1)
                Console.WriteLine(start + "->" + end);
            else
            {
                Hanoi(num - 1, start, end, temp);
                Console.WriteLine(start + "->" + end);
                Hanoi(num - 1, temp, start, end);
            }
        }
        #endregion
        #region Question 23
        static void QuickSort(int[] array)
        {
            Stack<int> stack = new Stack<int>();
            int PivotPoint;
            int low, high;
            stack.Push(0);
            stack.Push(array.Length - 1);
            while (stack.Count != 0)
            {
                high = stack.Pop();
                low = stack.Pop();
                if (high > low)
                {
                    PivotPoint = Partition(array, low, high);
                    stack.Push(low);
                    stack.Push(PivotPoint - 1);
                    stack.Push(PivotPoint + 1);
                    stack.Push(high);
                }
            }
        }
        static int Partition(int[] array, int low, int high)
        {
            int PivotItem = array[low];
            int j = low;
            int temp;
            for (int i = low + 1; i <= high; i++)
                if (array[i] < PivotItem)
                {
                    j++;
                    temp = array[i];
                    array[i] = array[j];
                    array[j] = temp;
                }
            temp = array[low];
            array[low] = array[j];
            array[j] = temp;
            return j;
        }
        #endregion
        #region Question 32
        static void Mul(int[] u, int m, out int[] Result)
        {
            Result = new int[u.Length + m];
            for (int i = 0; i < u.Length; i++)
                Result[i] = u[i];
            for (int i = u.Length; i < Result.Length; i++)
                Result[i] = 0;
        }
        static void Divide(int[] u, int m, out int[] Result)
        {
            Result = new int[u.Length - m];
            for (int i = 0; i < Result.Length; i++)
                Result[i] = u[i];
        }
        static void Rem(int[] u, int m, out int[] Result)
        {
            int j = u.Length - m;
            Result = new int[m];
            for (int i = 0; i < m; i++)
                Result[i] = u[j + i];
        }
        #endregion
        #region Question 37
        static int Fact(int n)
        {
            if (n == 1)
                return 1;
            else
                return n * Fact(n - 1);
        }
        #endregion
        #region Question 40
        static void SearchMat(int[,] Matrix, int key, int xlow, int xhigh, int ylow, int yhigh, ref int X, ref int Y)
        {
            if (xlow <= xhigh && ylow <= yhigh)
            {
                int xmid = (xlow + xhigh) / 2;
                int ymid = (ylow + yhigh) / 2;
                if (Matrix[xmid, ymid] == key)
                {
                    X = xmid;
                    Y = ymid;
                }
                else if (xlow == xhigh && ylow == yhigh)
                    return;
                else if (Matrix[xmid, ymid] > key)
                {
                    SearchMat(Matrix, key, xlow, xmid , ylow, ymid, ref X, ref Y);
                }
                else
                {
                    SearchMat(Matrix, key, xlow, xmid, ymid + 1, yhigh, ref X, ref Y);
                    SearchMat(Matrix, key, xmid + 1, xhigh, ylow, ymid, ref X, ref Y);
                    SearchMat(Matrix, key, xmid + 1, xhigh, ymid + 1, yhigh, ref X, ref Y);
                }
            }
        }
        #endregion
        #region Question 43
        static void FindOutweight(float[] Weights, int lowerBound, int higherBound, ref int result)
        {
            if ((higherBound - lowerBound) == 2)
            {
                if (Weights[lowerBound] > Weights[lowerBound + 1])
                {
                    result = lowerBound;
                }
                else if (Weights[lowerBound] == Weights[lowerBound + 1])
                {
                    result = higherBound;
                }
                else
                {
                    result = lowerBound + 1;
                }
            }
            else
            {
                int Group1Bound = (higherBound + lowerBound) / 3;
                int Group2Bound = 2 * (higherBound + lowerBound) / 3;
                float Group1Weight = CalcWeight(Weights, lowerBound, Group1Bound);
                float Group2Weight = CalcWeight(Weights, Group1Bound + 1, Group2Bound);
                if (Group1Weight == Group2Weight)
                {
                    FindOutweight(Weights, Group2Bound + 1, higherBound, ref result);
                }
                else if (Group1Weight > Group2Weight)
                {
                    FindOutweight(Weights, lowerBound, Group1Bound, ref result);
                }
                else
                {
                    FindOutweight(Weights, Group1Bound + 1, Group2Bound, ref result);
                }
            }
        }
        static float CalcWeight(float[] Weights, int lowerBound, int higherBound)
        {
            float result = 0;
            for (int i = lowerBound; i <= higherBound; i++)
            {
                result += Weights[i];
            }
            return result;
        }
        #endregion
        #region Question 44
        static int Mod(int x, int n, int p)
        {
            if (n == 0)
                return 1;
            if (n % 2 == 0)
            {
                int temp = Mod(x, n / 2, p);
                return (temp * temp) % p;
            }
            else
            {
                return ((x % p) * Mod(x, n - 1, p)) % p;
            }
        }
        #endregion
        #region Question 45
        static float MaxSublist(float[] Numbers, int lowerBound, int higherBound)
        {
            if (lowerBound == higherBound)
            {
                if (Numbers[lowerBound] > 0)
                {
                    return Numbers[lowerBound];
                }
                else
                {
                    return 0;
                }
            }
            else
            {
                int mid = (lowerBound + higherBound) / 2;
                float sum1 = MaxSublist(Numbers, lowerBound, mid);
                float sum2 = MaxSublist(Numbers, mid + 1, higherBound);
                float rbs = 0, mrbs = 0, lbs = 0, mlbs = 0;
                for (int i = mid; i >= lowerBound; i--)
                {
                    lbs += Numbers[i];
                    if (lbs > mlbs)
                    {
                        mlbs = lbs;
                    }
                }
                for (int i = mid + 1; i <= higherBound; i++)
                {
                    rbs += Numbers[i];
                    if (rbs > mrbs)
                    {
                        mrbs = rbs;
                    }
                }
                return Math.Max(Math.Max(mrbs + mlbs, sum1), sum2);
            }
        }
        #endregion
        static void Main(string[] args)
        {
            int[] arr = { 6, 2, 0, 3, 4, 5, 1 };
            int[] sarr = { 0, 1, 2, 4, 3, 5, 6 };
            Console.WriteLine("-------------------------------------------------------------// 3");
            Console.WriteLine("Ans 3 : " + BinSearch2(sarr, 4, 0, sarr.Length - 1));
            Console.WriteLine("-------------------------------------------------------------// 6");
            Console.WriteLine("Ans 6 : " + BinSearch3(sarr, 10, 0, sarr.Length - 1));
            Console.WriteLine("-------------------------------------------------------------// 7");
            int max = -1;
            FindMax(arr, ref max, 0, arr.Length - 1);
            Console.WriteLine("Ans 7 : " + max);
            Console.WriteLine("-------------------------------------------------------------// 8");
            Initial(arr);
            int[] p1, p2;
            MaxPartition(arr, out p1, out p2);
            Print(p1);
            Print(p2);
            Console.WriteLine("-------------------------------------------------------------// 11");
            Initial(arr);
            MergeSort2(arr);
            Print(arr);
            Console.WriteLine("-------------------------------------------------------------// 13");
            Initial(arr);
            MergeSort3(arr, 0, arr.Length - 1);
            Print(arr);
            Console.WriteLine("-------------------------------------------------------------// 17");
            Hanoi(3, 'A', 'B', 'C');
            Console.WriteLine("-------------------------------------------------------------// 23");
            Initial(arr);
            QuickSort(arr);
            Print(arr);
            Console.WriteLine("-------------------------------------------------------------// 32");
            Initial(arr);
            int[] res;
            Mul(arr, 4, out res);
            Print(res);
            Divide(arr, 4, out res);
            Print(res);
            Rem(arr, 4, out res);
            Print(res);
            Console.WriteLine("-------------------------------------------------------------// 37");
            Console.WriteLine("Answer 37 : " + Fact(11));
            Console.WriteLine("-------------------------------------------------------------// 39");
            int[,] mat = { { 1, 2, 3, 4, 5 }, { 6, 7, 8, 9, 10 }, { 11, 12, 13, 14, 15 }, { 16, 17, 18, 19, 20 } };
            int X = -1, Y = -1;
            SearchMat(mat, 10, 0, mat.GetLength(0) - 1, 0, mat.GetLength(1) - 1, ref X, ref Y);
            Console.WriteLine("X=" + X + " Y=" + Y);
            Console.WriteLine("-------------------------------------------------------------// 43");
            float[] Weights = new float[] { 2, 2, 2, 2, 2, 2, 2, 3, 2 };
            int result = -1;
            FindOutweight(Weights, 0, 8, ref result);
            Console.WriteLine("Answer 43 : " + result);
            Console.WriteLine("-------------------------------------------------------------// 45");
            float[] Numbers = new float[] { 2, -1, 3, -2, -2, 2, 1, -2, 2 };
            Console.WriteLine("Answer 45 : " + MaxSublist(Numbers, 0, 8));
            Console.ReadKey();
        }
        #region Initial
        static void Initial(int[] array)
        {
            array[0] = 6; array[1] = 2; array[2] = 0; array[3] = 3; array[4] = 4; array[5] = 5; array[6] = 1;
        }
        #endregion
        #region Print
        static void Print(int[] array)
        {
            for (int i = 0; i < array.Length; i++)
                Console.Write(" " + array[i]);
            Console.WriteLine();
        }
        #endregion
    }
}
